/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.memory;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.Bits;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.ReadOnlyHeapBuffer;

public class HeapBuffer
implements Buffer {
    public static volatile boolean DEBUG_MODE = false;
    protected boolean allowBufferDispose = false;
    protected Exception disposeStackTrace;
    protected byte[] heap;
    protected int offset;
    protected int pos;
    protected int cap;
    protected int lim;
    protected int mark = -1;
    protected boolean readOnly;
    protected ByteOrder order = ByteOrder.BIG_ENDIAN;
    protected boolean bigEndian = true;
    protected ByteBuffer byteBuffer;

    protected HeapBuffer() {
    }

    protected HeapBuffer(byte[] heap, int offset, int cap) {
        this.heap = heap;
        this.offset = offset;
        this.lim = this.cap = cap;
    }

    @Override
    public final boolean isComposite() {
        return false;
    }

    @Override
    public HeapBuffer prepend(Buffer header) {
        this.checkDispose();
        return this;
    }

    @Override
    public void trim() {
        this.checkDispose();
        this.flip();
    }

    @Override
    public void shrink() {
        this.checkDispose();
    }

    @Override
    public final boolean allowBufferDispose() {
        return this.allowBufferDispose;
    }

    @Override
    public final void allowBufferDispose(boolean allowBufferDispose) {
        this.allowBufferDispose = allowBufferDispose;
    }

    @Override
    public final boolean tryDispose() {
        if (this.allowBufferDispose) {
            this.dispose();
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        this.prepareDispose();
        this.byteBuffer = null;
        this.heap = null;
        this.pos = 0;
        this.offset = 0;
        this.lim = 0;
        this.cap = 0;
        this.order = ByteOrder.BIG_ENDIAN;
        this.bigEndian = true;
    }

    protected final void prepareDispose() {
        this.checkDispose();
        if (DEBUG_MODE) {
            DebugLogic.doDebug(this);
        }
    }

    @Override
    public ByteBuffer underlying() {
        this.checkDispose();
        return this.toByteBuffer();
    }

    @Override
    public final int capacity() {
        this.checkDispose();
        return this.cap;
    }

    @Override
    public final int position() {
        this.checkDispose();
        return this.pos;
    }

    @Override
    public final HeapBuffer position(int newPosition) {
        this.checkDispose();
        this.pos = newPosition;
        if (this.mark > this.pos) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public final int limit() {
        this.checkDispose();
        return this.lim;
    }

    @Override
    public final HeapBuffer limit(int newLimit) {
        this.checkDispose();
        this.lim = newLimit;
        if (this.mark > this.lim) {
            this.mark = -1;
        }
        return this;
    }

    @Override
    public final HeapBuffer mark() {
        this.mark = this.pos;
        return this;
    }

    @Override
    public final HeapBuffer reset() {
        int m = this.mark;
        if (m < 0) {
            throw new InvalidMarkException();
        }
        this.pos = m;
        return this;
    }

    @Override
    public final HeapBuffer clear() {
        this.pos = 0;
        this.lim = this.cap;
        this.mark = -1;
        return this;
    }

    @Override
    public final HeapBuffer flip() {
        this.lim = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public final HeapBuffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    @Override
    public final int remaining() {
        return this.lim - this.pos;
    }

    @Override
    public final boolean hasRemaining() {
        return this.pos < this.lim;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public Buffer split(int splitPosition) {
        this.checkDispose();
        int oldPosition = this.pos;
        int oldLimit = this.lim;
        HeapBuffer ret = this.createHeapBuffer(splitPosition, this.cap - splitPosition);
        this.cap = splitPosition;
        if (oldPosition < splitPosition) {
            this.pos = oldPosition;
        } else {
            this.pos = this.cap;
            ret.position(oldPosition - splitPosition);
        }
        if (oldLimit < splitPosition) {
            this.lim = oldLimit;
            ret.limit(0);
        } else {
            this.lim = this.cap;
            ret.limit(oldLimit - splitPosition);
        }
        return ret;
    }

    @Override
    public HeapBuffer slice() {
        return this.slice(this.pos, this.lim);
    }

    @Override
    public HeapBuffer slice(int position2, int limit) {
        this.checkDispose();
        return this.createHeapBuffer(position2, limit - position2);
    }

    @Override
    public HeapBuffer duplicate() {
        this.checkDispose();
        HeapBuffer duplicate = this.createHeapBuffer(0, this.cap);
        duplicate.position(this.pos);
        duplicate.limit(this.lim);
        return duplicate;
    }

    @Override
    public HeapBuffer asReadOnlyBuffer() {
        this.checkDispose();
        this.onShareHeap();
        ReadOnlyHeapBuffer b = new ReadOnlyHeapBuffer(this.heap, this.offset, this.cap);
        b.pos = this.pos;
        b.lim = this.lim;
        return b;
    }

    @Override
    public byte get() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
        return this.heap[this.offset + this.pos++];
    }

    @Override
    public byte get(int index2) {
        if (index2 < 0 || index2 >= this.lim) {
            throw new IndexOutOfBoundsException();
        }
        return this.heap[this.offset + index2];
    }

    @Override
    public HeapBuffer put(byte b) {
        if (!this.hasRemaining()) {
            throw new BufferOverflowException();
        }
        this.heap[this.offset + this.pos++] = b;
        return this;
    }

    @Override
    public HeapBuffer put(int index2, byte b) {
        if (index2 < 0 || index2 >= this.lim) {
            throw new IndexOutOfBoundsException();
        }
        this.heap[this.offset + index2] = b;
        return this;
    }

    @Override
    public HeapBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public HeapBuffer get(byte[] dst, int offset, int length) {
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
        System.arraycopy(this.heap, this.offset + this.pos, dst, offset, length);
        this.pos += length;
        return this;
    }

    @Override
    public HeapBuffer put(Buffer src) {
        this.put(src, src.position(), src.remaining());
        src.position(src.limit());
        return this;
    }

    @Override
    public HeapBuffer put(Buffer src, int position2, int length) {
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        int oldPos = src.position();
        int oldLim = src.limit();
        int thisPos = this.pos;
        Buffers.setPositionLimit(src, position2, position2 + length);
        src.get(this.heap, this.offset + thisPos, length);
        Buffers.setPositionLimit(src, oldPos, oldLim);
        this.pos = thisPos + length;
        return this;
    }

    @Override
    public Buffer get(ByteBuffer dst) {
        int length = dst.remaining();
        dst.put(this.heap, this.offset + this.pos, length);
        this.pos += length;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer get(ByteBuffer dst, int position2, int length) {
        int oldPos = dst.position();
        int oldLim = dst.limit();
        try {
            Buffers.setPositionLimit(dst, position2, position2 + length);
            dst.put(this.heap, this.offset + this.pos, length);
            this.pos += length;
        }
        finally {
            Buffers.setPositionLimit(dst, oldPos, oldLim);
        }
        return this;
    }

    @Override
    public Buffer put(ByteBuffer src) {
        int length = src.remaining();
        src.get(this.heap, this.offset + this.pos, length);
        this.pos += length;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Buffer put(ByteBuffer src, int position2, int length) {
        int oldPos = src.position();
        int oldLim = src.limit();
        try {
            Buffers.setPositionLimit(src, position2, position2 + length);
            src.get(this.heap, this.offset + this.pos, length);
            this.pos += length;
        }
        finally {
            Buffers.setPositionLimit(src, oldPos, oldLim);
        }
        return this;
    }

    public static HeapBuffer wrap(byte[] heap) {
        return HeapBuffer.wrap(heap, 0, heap.length);
    }

    public static HeapBuffer wrap(byte[] heap, int off, int len) {
        return new HeapBuffer(heap, off, len);
    }

    @Override
    public HeapBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public HeapBuffer put(byte[] src, int offset, int length) {
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, offset, this.heap, this.offset + this.pos, length);
        this.pos += length;
        return this;
    }

    @Override
    public HeapBuffer put8BitString(String s2) {
        int len = s2.length();
        if (this.remaining() < len) {
            throw new BufferOverflowException();
        }
        s2.getBytes(0, len, this.heap, this.offset + this.pos);
        this.pos += len;
        return this;
    }

    @Override
    public HeapBuffer compact() {
        int length = this.remaining();
        System.arraycopy(this.heap, this.offset + this.pos, this.heap, this.offset, length);
        this.pos = length;
        this.lim = this.cap;
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.order;
    }

    @Override
    public HeapBuffer order(ByteOrder bo) {
        this.order = bo;
        this.bigEndian = this.order == ByteOrder.BIG_ENDIAN;
        return this;
    }

    @Override
    public char getChar() {
        if (this.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        char c = Bits.getChar(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 2;
        return c;
    }

    @Override
    public char getChar(int index2) {
        if (index2 < 0 || index2 >= this.lim - 1) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getChar(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putChar(char value2) {
        if (this.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        Bits.putChar(this.heap, this.offset + this.pos, value2, this.bigEndian);
        this.pos += 2;
        return this;
    }

    @Override
    public HeapBuffer putChar(int index2, char value2) {
        if (index2 < 0 || index2 >= this.lim - 1) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putChar(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    @Override
    public short getShort() {
        if (this.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        short s2 = Bits.getShort(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 2;
        return s2;
    }

    @Override
    public short getShort(int index2) {
        if (index2 < 0 || index2 >= this.lim - 1) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getShort(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putShort(short value2) {
        if (this.remaining() < 2) {
            throw new BufferUnderflowException();
        }
        Bits.putShort(this.heap, this.offset + this.pos, value2, this.bigEndian);
        this.pos += 2;
        return this;
    }

    @Override
    public HeapBuffer putShort(int index2, short value2) {
        if (index2 < 0 || index2 >= this.lim - 1) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putShort(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    @Override
    public int getInt() {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException();
        }
        int i = Bits.getInt(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 4;
        return i;
    }

    @Override
    public int getInt(int index2) {
        if (index2 < 0 || index2 >= this.lim - 3) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getInt(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putInt(int value2) {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException();
        }
        Bits.putInt(this.heap, this.offset + this.pos, value2, this.bigEndian);
        this.pos += 4;
        return this;
    }

    @Override
    public HeapBuffer putInt(int index2, int value2) {
        if (index2 < 0 || index2 >= this.lim - 3) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putInt(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    @Override
    public long getLong() {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        long l = Bits.getLong(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 8;
        return l;
    }

    @Override
    public long getLong(int index2) {
        if (index2 < 0 || index2 >= this.lim - 7) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getLong(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putLong(long value2) {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        Bits.putLong(this.heap, this.offset + this.pos, value2, this.bigEndian);
        this.pos += 8;
        return this;
    }

    @Override
    public HeapBuffer putLong(int index2, long value2) {
        if (index2 < 0 || index2 >= this.lim - 7) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putLong(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    @Override
    public float getFloat() {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException();
        }
        float f2 = Bits.getFloat(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 4;
        return f2;
    }

    @Override
    public float getFloat(int index2) {
        if (index2 < 0 || index2 >= this.lim - 3) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getFloat(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putFloat(float value2) {
        if (this.remaining() < 4) {
            throw new BufferUnderflowException();
        }
        Bits.putFloat(this.heap, this.offset + this.pos, value2, this.bigEndian);
        this.pos += 4;
        return this;
    }

    @Override
    public HeapBuffer putFloat(int index2, float value2) {
        if (index2 < 0 || index2 >= this.lim - 3) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putFloat(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    @Override
    public double getDouble() {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        double d = Bits.getDouble(this.heap, this.offset + this.pos, this.bigEndian);
        this.pos += 8;
        return d;
    }

    @Override
    public double getDouble(int index2) {
        if (index2 < 0 || index2 >= this.lim - 7) {
            throw new IndexOutOfBoundsException();
        }
        return Bits.getDouble(this.heap, this.offset + index2, this.bigEndian);
    }

    @Override
    public HeapBuffer putDouble(double value2) {
        if (this.remaining() < 8) {
            throw new BufferUnderflowException();
        }
        Bits.putDouble(this.heap, this.offset + this.pos, value2, this.bigEndian);
        return this;
    }

    @Override
    public HeapBuffer putDouble(int index2, double value2) {
        if (index2 < 0 || index2 >= this.lim - 7) {
            throw new IndexOutOfBoundsException();
        }
        Bits.putDouble(this.heap, this.offset + index2, value2, this.bigEndian);
        return this;
    }

    public int hashCode() {
        int result2 = this.allowBufferDispose ? 1 : 0;
        result2 = 31 * result2 + (this.disposeStackTrace != null ? this.disposeStackTrace.hashCode() : 0);
        result2 = 31 * result2 + (this.heap != null ? Arrays.hashCode(this.heap) : 0);
        result2 = 31 * result2 + this.offset;
        result2 = 31 * result2 + this.pos;
        result2 = 31 * result2 + this.cap;
        result2 = 31 * result2 + this.lim;
        result2 = 31 * result2 + this.mark;
        result2 = 31 * result2 + (this.readOnly ? 1 : 0);
        result2 = 31 * result2 + (this.order != null ? this.order.hashCode() : 0);
        result2 = 31 * result2 + (this.bigEndian ? 1 : 0);
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer that = (Buffer)obj;
            if (this.remaining() != that.remaining()) {
                return false;
            }
            int p = this.position();
            int i = this.limit() - 1;
            int j = that.limit() - 1;
            while (i >= p) {
                byte v2;
                byte v1 = this.get(i);
                if (v1 != (v2 = that.get(j))) {
                    return false;
                }
                --i;
                --j;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Buffer o) {
        int n = this.position() + Math.min(this.remaining(), o.remaining());
        int i = this.position();
        int j = o.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = o.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - o.remaining();
    }

    protected void checkDispose() {
        if (this.heap == null) {
            throw new IllegalStateException("HeapBuffer has already been disposed", this.disposeStackTrace);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HeapBuffer (" + System.identityHashCode(this) + ") ");
        sb.append("[pos=");
        sb.append(this.pos);
        sb.append(" lim=");
        sb.append(this.lim);
        sb.append(" cap=");
        sb.append(this.cap);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String toStringContent() {
        return this.toStringContent(Charset.defaultCharset(), this.pos, this.lim);
    }

    @Override
    public String toStringContent(Charset charset) {
        return this.toStringContent(charset, this.pos, this.lim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toStringContent(Charset charset, int position2, int limit) {
        this.checkDispose();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        boolean isRestoreByteBuffer = this.byteBuffer != null;
        int oldPosition = 0;
        int oldLimit = 0;
        if (isRestoreByteBuffer) {
            oldPosition = this.byteBuffer.position();
            oldLimit = this.byteBuffer.limit();
        }
        ByteBuffer bb = this.toByteBuffer0(position2, limit, false);
        try {
            String string2 = charset.decode(bb).toString();
            return string2;
        }
        finally {
            if (isRestoreByteBuffer) {
                Buffers.setPositionLimit(this.byteBuffer, oldPosition, oldLimit);
            }
        }
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.pos, this.lim);
    }

    @Override
    public ByteBuffer toByteBuffer(int position2, int limit) {
        return this.toByteBuffer0(position2, limit, false);
    }

    @Override
    public final ByteBufferArray toByteBufferArray() {
        ByteBufferArray array = ByteBufferArray.create();
        array.add(this.toByteBuffer());
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(int position2, int limit) {
        return this.toByteBufferArray(ByteBufferArray.create(), position2, limit);
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array) {
        array.add(this.toByteBuffer());
        return array;
    }

    @Override
    public final ByteBufferArray toByteBufferArray(ByteBufferArray array, int position2, int limit) {
        array.add(this.toByteBuffer(position2, limit));
        return array;
    }

    @Override
    public final BufferArray toBufferArray() {
        BufferArray array = BufferArray.create();
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(int position2, int limit) {
        return this.toBufferArray(BufferArray.create(), position2, limit);
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array) {
        array.add(this);
        return array;
    }

    @Override
    public final BufferArray toBufferArray(BufferArray array, int position2, int limit) {
        int oldPos = this.pos;
        int oldLim = this.lim;
        this.pos = position2;
        this.lim = limit;
        array.add(this, oldPos, oldLim);
        return array;
    }

    @Override
    public boolean release() {
        return this.tryDispose();
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public int arrayOffset() {
        return this.offset;
    }

    @Override
    public byte[] array() {
        return this.heap;
    }

    protected void onShareHeap() {
    }

    protected HeapBuffer createHeapBuffer(int offs, int capacity) {
        this.onShareHeap();
        return new HeapBuffer(this.heap, offs + this.offset, capacity);
    }

    protected ByteBuffer toByteBuffer0(int pos, int lim, boolean slice2) {
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.wrap(this.heap);
        }
        Buffers.setPositionLimit(this.byteBuffer, this.offset + pos, this.offset + lim);
        return slice2 ? this.byteBuffer.slice() : this.byteBuffer;
    }

    private static class DebugLogic {
        private DebugLogic() {
        }

        static void doDebug(HeapBuffer heapBuffer) {
            heapBuffer.clear();
            while (heapBuffer.hasRemaining()) {
                heapBuffer.put((byte)-1);
            }
            heapBuffer.flip();
            heapBuffer.disposeStackTrace = new Exception("HeapBuffer was disposed from: ");
        }
    }
}

